/*
 * Decompiled with CFR 0.152.
 */
package main;

import control.MainControl;
import control.MenuControl;
import data.Constants;
import data.Theme;
import org.lwjgl.opengl.Display;
import view.StaticDrawer;
import view.View;

public class Game {
    private static MainControl mainControl;
    public static View gameScreen;
    private static boolean isPlaying;
    static long lastFPS;
    static long fps;
    private static final long GAME_START_TIME;

    static {
        gameScreen = null;
        lastFPS = 0L;
        fps = 0L;
        GAME_START_TIME = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        StaticDrawer.initializeDistances();
        Theme.initialize();
        Game currentGame = new Game();
        mainControl = new MainControl(Constants.MAX_NUM_ENEMIES);
        currentGame.run();
    }

    public Game() {
        gameScreen = new View(Constants.FRAMES_PER_SECOND);
        isPlaying = true;
    }

    public void run() {
        while (isPlaying) {
            this.checkIfGameShouldEnd();
            if (isPlaying) {
                gameScreen.update();
            }
            mainControl.update();
        }
    }

    public static void startGame() {
        Constants.currentGameState = 1;
        if (!MainControl.songBegin) {
            try {
                mainControl.newGame();
            }
            catch (Exception e) {
                MainControl.songBegin = false;
                Constants.currentGameState = 0;
                MenuControl.menuReset();
                MenuControl.error = String.valueOf(Constants.SONG_TO_USE) + " could not be played!";
                MenuControl.errorFade = 0.0f;
            }
            lastFPS = Game.getTime();
        }
    }

    public static long getTime() {
        return System.nanoTime() / 1000000L;
    }

    public void updateFPS() {
        if (Game.getTime() - lastFPS > 1000L) {
            Display.setTitle("FPS: " + fps);
            fps = 0L;
            lastFPS += 1000L;
        }
        ++fps;
    }

    public void checkIfGameShouldEnd() {
        if (gameScreen.closeRequested()) {
            isPlaying = false;
            gameScreen.destroy();
            mainControl.closeRequested();
        }
    }

    public static long getMillisecondTimeSinceStart() {
        return System.currentTimeMillis() - GAME_START_TIME;
    }
}

